/*
   Copyright (c) 2019-2023 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

MEMORY
{

   BOOT_RSVD      : origin = 0x000002, length = 0x0000F3     /* Part of M0, BOOT rom will use this for stack */
   RAMM0          : origin = 0x0000F6, length = 0x00030A
   RAMM1          : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */


   //RAMLS01_RSVD  : origin = 0x008000, length = 0x001000		/* Can't be used, reserved for FAST object */
   //RAMLS2_RSVD   : origin = 0x009000, length = 0x000100		/* */
   //RAMLS2_3_RSVD : origin = 0x009100, length = 0x000F00		/* */

   RAMLS	         : origin = 0x00A000, length = 0x001F00
   //RAMLS0       : origin = 0x008000, length = 0x000800
   //RAMLS1       : origin = 0x008800, length = 0x000800
   //RAMLS2       : origin = 0x009000, length = 0x000800
   //RAMLS3       : origin = 0x009800, length = 0x000800
   //RAMLS4       : origin = 0x00A000, length = 0x000800
   //RAMLS5       : origin = 0x00A800, length = 0x000800
   //RAMLS6       : origin = 0x00B000, length = 0x000800
   //RAMLS7       : origin = 0x00B800, length = 0x000800
   RAMLS7_RSVD    : origin = 0x00BF00, length = 0x000100  // JTAG communication buffer

   // PRAMGS allocated for data to allow space for functions in RAMLS
   PRAMGS       	: origin = 0x00C000, length = 0x008000

   RESET          : origin = 0x3FFFC0, length = 0x000002

   BEGIN          : origin = 0x080000, length = 0x000002     // Flash Bank 0
      /* Flash sectors */
   /* BANK 0 */
   FLASH_BANK0	    : origin = 0x080002, length = 0x00FFFE	/* on-chip Flash */
   //FLASH_BANK0_SEC1_RSVD  : origin = 0x081000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC2_RSVD  : origin = 0x082000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC3_RSVD  : origin = 0x083000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC4_RSVD  : origin = 0x084000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC5_RSVD  : origin = 0x085000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC6_RSVD  : origin = 0x086000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC7_RSVD  : origin = 0x087000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC8_RSVD  : origin = 0x088000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC9_RSVD  : origin = 0x089000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC10_RSVD : origin = 0x08A000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC11_RSVD : origin = 0x08B000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC12_RSVD : origin = 0x08C000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC13_RSVD : origin = 0x08D000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC14_RSVD : origin = 0x08E000, length = 0x001000	/* on-chip Flash */
   //FLASH_BANK0_SEC15_RSVD : origin = 0x08F000, length = 0x001000	/* on-chip Flash */

   /* BANK 1 */
   FLASH_BANK1_SEC0_RSVD  : origin = 0x090000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC1_RSVD  : origin = 0x091000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC2_RSVD  : origin = 0x092000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC3_RSVD  : origin = 0x093000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC4_RSVD  : origin = 0x094000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC5_RSVD  : origin = 0x095000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC6_RSVD  : origin = 0x096000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC7_RSVD  : origin = 0x097000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC8_RSVD  : origin = 0x098000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC9_RSVD  : origin = 0x099000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC10_RSVD : origin = 0x09A000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC11_RSVD : origin = 0x09B000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC12_RSVD : origin = 0x09C000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC13_RSVD : origin = 0x09D000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC14_RSVD : origin = 0x09E000, length = 0x001000	/* on-chip Flash */
   FLASH_BANK1_SEC15_RSVD : origin = 0x09F000, length = 0x001000	/* on-chip Flash */

   patch_EST_Angle_run_patchable_address           : origin = 0x009000, length = 0x00000e
   patch_EST_Dir_run_patchable_address             : origin = 0x00900e, length = 0x00000e
   patch_EST_Eab_run_patchable_address             : origin = 0x00901c, length = 0x00000e
   patch_EST_Flux_ab_estFluxDot_patchable_address  : origin = 0x00902a, length = 0x00000e
   patch_EST_Flux_dq_run_patchable_address         : origin = 0x009038, length = 0x00000e
   patch_EST_Flux_run_patchable_address            : origin = 0x009046, length = 0x00000e
   patch_EST_Freq_run_patchable_address            : origin = 0x009054, length = 0x00000e
   patch_EST_Iab_run_patchable_address             : origin = 0x009062, length = 0x00000e
   patch_EST_Idq_run_patchable_address             : origin = 0x009070, length = 0x00000e
   patch_EST_Ls_run_patchable_address              : origin = 0x00907e, length = 0x00000e
   patch_EST_OneOverDcBus_run_patchable_address    : origin = 0x00908c, length = 0x00000e
   patch_EST_Rr_run_patchable_address              : origin = 0x00909a, length = 0x00000e
   patch_EST_RsOnLine_run_patchable_address        : origin = 0x0090a8, length = 0x00000e
   patch_EST_Rs_run_patchable_address              : origin = 0x0090b6, length = 0x00000e
   patch_EST_Vab_run_patchable_address             : origin = 0x0090c4, length = 0x00000e
   patch_EST_Vdq_run_patchable_address             : origin = 0x0090d2, length = 0x00000e
   patch_EST_runEst_patchable_address              : origin = 0x0090e0, length = 0x00000e

}

SECTIONS
{
   scope            : > RAMLS, ALIGN(2)
   step             : > FLASH_BANK0, ALIGN(4)
   dispatch         : > FLASH_BANK0, ALIGN(4)

   codestart        : > BEGIN, ALIGN(4)
   .text            : > FLASH_BANK0, ALIGN(4)
   .cinit           : > FLASH_BANK0, ALIGN(4)
   .switch          : > FLASH_BANK0, ALIGN(4)

   .stack           : > RAMM1 | RAMLS

#if defined(__TI_EABI__)
   .init_array      : > FLASH_BANK0, ALIGN(4)
   .const           : > FLASH_BANK0, ALIGN(4)
   .bss             : > PRAMGS
   .bss:output      : > PRAMGS
   .bss:cio         : > PRAMGS
   .data            : > PRAMGS
   .sysmem          : > PRAMGS
#else
   .pinit           : > FLASH_BANK0, ALIGN(4)
   .econst          : > FLASH_BANK0, ALIGN(4)
   .cio             : > FLASH_BANK0, ALIGN(4)
   .ebss            : > PRAMGS
   .esysmem         : > PRAMGS
#endif

    GROUP      : LOAD = FLASH_BANK0,
                RUN = RAMLS,
#if defined(__TI_EABI__)
                LOAD_START(RamfuncsLoadStart),
                LOAD_END(RamfuncsLoadEnd),
                RUN_START(RamfuncsRunStart),
                LOAD_SIZE(RamfuncsLoadSize),
#else
                LOAD_START(_RamfuncsLoadStart),
                LOAD_END(_RamfuncsLoadEnd),
                RUN_START(_RamfuncsRunStart),
                LOAD_SIZE(_RamfuncsLoadSize),
#endif
                ALIGN(4)
   {
      ramfuncs
      .TI.ramfunc
   }
   .reset           : > RESET, TYPE = DSECT /* not used, */

   patch_EST_Angle_run_patchable_section           : >  patch_EST_Angle_run_patchable_address,           PAGE = 0
   patch_EST_Dir_run_patchable_section             : >  patch_EST_Dir_run_patchable_address,             PAGE = 0
   patch_EST_Eab_run_patchable_section             : >  patch_EST_Eab_run_patchable_address,             PAGE = 0
   patch_EST_Flux_ab_estFluxDot_patchable_section  : >  patch_EST_Flux_ab_estFluxDot_patchable_address,  PAGE = 0
   patch_EST_Flux_dq_run_patchable_section         : >  patch_EST_Flux_dq_run_patchable_address,         PAGE = 0
   patch_EST_Flux_run_patchable_section            : >  patch_EST_Flux_run_patchable_address,            PAGE = 0
   patch_EST_Freq_run_patchable_section            : >  patch_EST_Freq_run_patchable_address,            PAGE = 0
   patch_EST_Iab_run_patchable_section             : >  patch_EST_Iab_run_patchable_address,             PAGE = 0
   patch_EST_Idq_run_patchable_section             : >  patch_EST_Idq_run_patchable_address,             PAGE = 0
   patch_EST_Ls_run_patchable_section              : >  patch_EST_Ls_run_patchable_address,              PAGE = 0
   patch_EST_OneOverDcBus_run_patchable_section    : >  patch_EST_OneOverDcBus_run_patchable_address,    PAGE = 0
   patch_EST_Rr_run_patchable_section              : >  patch_EST_Rr_run_patchable_address,              PAGE = 0
   patch_EST_RsOnLine_run_patchable_section        : >  patch_EST_RsOnLine_run_patchable_address,        PAGE = 0
   patch_EST_Rs_run_patchable_section              : >  patch_EST_Rs_run_patchable_address,              PAGE = 0
   patch_EST_Vab_run_patchable_section             : >  patch_EST_Vab_run_patchable_address,             PAGE = 0
   patch_EST_Vdq_run_patchable_section             : >  patch_EST_Vdq_run_patchable_address,             PAGE = 0
   patch_EST_runEst_patchable_section              : >  patch_EST_runEst_patchable_address,              PAGE = 0
 }
