/*
   Copyright (c) 2025 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef PLX_DAC_IMPL_H_
#define PLX_DAC_IMPL_H_

typedef enum PLX_DAC_UNIT { PLX_DAC_A = 0, PLX_DAC_B } PLX_DAC_Unit_t;

// FIXME: avoid duplication with plx_ain_impl.h

// Definitions for specifying reference mode
#define ADC_INTERNAL    0x0
#define ADC_EXTERNAL    0x1
#define ADC_VDDA        0x3

// Definitions for specifying reference voltage
#define ADC_VREF3P3     1
#define ADC_VREF2P5     0

//
// Definitions for specifying an ADC
#define ADC_ADCA        0
#define ADC_ADCB        1
#define ADC_ADCC        2
#define ADC_ADCD        3
#define ADC_ADCE        4

#include "dac_type2.h"

#endif /* PLX_DAC_IMPL_H_ */
