--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]--
local Module = {}
local U = require('common.utils')

local static = {}

function Module.getBlock(globals, cpu)

  local IpcTransmit = require('common.block').getBlock(globals, cpu)
  if not static[cpu] then
    static[cpu] = {
      numInstances = 0,
      numChannels = 0,
      instances = {},
      finalized = false,
    }
  end
  IpcTransmit["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function IpcTransmit:checkMaskParameters()
  end

  function IpcTransmit:createImplicit(params, req)
    table.insert(static[self.cpu].instances, self.bid)

    self.cpuConfig = {}
    self.cpuConfig['local_cpu'] = self.cpu + 1
    if self.cpu == 0 then
      self.cpuConfig['remote_cpu'] = 2
    else
      self.cpuConfig['remote_cpu'] = 1
    end

    self.datatype = params.datatype
    self.index = params.index

    -- see if a IPC object as already been created
    local ipc_obj = self:getBlockInstance('ipc')


    if ipc_obj == nil then
      -- create new IPC object
      ipc_obj = self:makeBlock('ipc', self.cpu)
      ipc_obj:createImplicit()
    end
    ipc_obj:registerIpcRxTxBlock(self.index, {
      datatype = self.datatype,
      from = self.cpuConfig['local_cpu'],
      to = self.cpuConfig['remote_cpu'] 
    })
    
  end

  function IpcTransmit:p_getDirectFeedthroughCode()
    U.error("Explicit use not supported.")
  end

  function IpcTransmit:finalizeThis(c)

    c.PostInitCode:append('PLX_IPC_setup(IpcHandles[%(index)i], &%(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_p->ipc%(index)i[0], &%(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_p->ipc%(index)i[1]);' % {
      index = self.index,
      base_name = Target.Variables.BASE_NAME,
      local_cpu = self.cpuConfig['local_cpu'],
      remote_cpu = self.cpuConfig['remote_cpu']
    })
    local code = [[
       %(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_sema_p->sema%(index)i[0] = -1;
       %(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_sema_p->sema%(index)i[1] = 0;

       PLX_IPC_semaphoreSetup(IpcHandles[%(index)i], &%(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_sema_p->sema%(index)i[0], &%(base_name)s_CPU%(remote_cpu)i_TO_CPU%(local_cpu)i_sema_p->sema%(index)i[0], &%(base_name)s_CPU%(local_cpu)i_TO_CPU%(remote_cpu)i_sema_p->sema%(index)i[1]);
    ]] % {
      index = self.index,
      base_name = Target.Variables.BASE_NAME,
      local_cpu = self.cpuConfig['local_cpu'],
      remote_cpu = self.cpuConfig['remote_cpu']
    }
    c.PostInitCode:append(code)
  end

  function IpcTransmit:finalize(c)
    if static[self.cpu].finalized then
      return
    end

    for _, bid in ipairs(static[self.cpu].instances) do
      local ipcTransmit = globals.instances[bid]
      if ipcTransmit:getCpu() == self.cpu then
        ipcTransmit:finalizeThis(c)
      end
    end

    static[self.cpu].finalized = true
  end

  return IpcTransmit
end

return Module