local P = {}

function P.getPinSettings(pin)
	local pin_map = {
	  GPIO_0_GPIO0                    = 0x00060000,
	  GPIO_0_EPWM1_A                  = 0x00060001,
	  GPIO_0_I2CA_SDA                 = 0x00060006,
	  GPIO_0_SPIA_STE                 = 0x00060007,
	  GPIO_0_FSIRXA_CLK               = 0x00060009,
	  GPIO_0_MCAN_RX                  = 0x0006000A,
	  GPIO_0_CLB_OUTPUTXBAR8          = 0x0006000B,
	  GPIO_0_EQEP1_INDEX              = 0x0006000D,
	  GPIO_0_HIC_D7                   = 0x0006000E,
	  GPIO_0_HIC_BASESEL1             = 0x0006000F,
		
	  GPIO_1_GPIO1                    = 0x00060200,
	  GPIO_1_EPWM1_B                  = 0x00060201,
	  GPIO_1_I2CA_SCL                 = 0x00060206,
	  GPIO_1_SPIA_SOMI                = 0x00060207,
	  GPIO_1_MCAN_TX                  = 0x0006020A,
	  GPIO_1_CLB_OUTPUTXBAR7          = 0x0006020B,
	  GPIO_1_HIC_A2                   = 0x0006020D,
	  GPIO_1_FSITXA_TDM_D1            = 0x0006020E,
	  GPIO_1_HIC_D10                  = 0x0006020F,
		
	  GPIO_2_GPIO2                    = 0x00060400,
	  GPIO_2_EPWM2_A                  = 0x00060401,
	  GPIO_2_OUTPUTXBAR1              = 0x00060405,
	  GPIO_2_PMBUSA_SDA               = 0x00060406,
	  GPIO_2_SPIA_SIMO                = 0x00060407,
	  GPIO_2_SCIA_TX                  = 0x00060409,
	  GPIO_2_FSIRXA_D1                = 0x0006040A,
	  GPIO_2_I2CB_SDA                 = 0x0006040B,
	  GPIO_2_HIC_A1                   = 0x0006040D,
	  GPIO_2_CANA_TX                  = 0x0006040E,
	  GPIO_2_HIC_D9                   = 0x0006040F,
		
	  GPIO_3_GPIO3                    = 0x00060600,
	  GPIO_3_EPWM2_B                  = 0x00060601,
	  GPIO_3_OUTPUTXBAR2              = 0x00060602,
	  GPIO_3_PMBUSA_SCL               = 0x00060606,
	  GPIO_3_SPIA_CLK                 = 0x00060607,
	  GPIO_3_SCIA_RX                  = 0x00060609,
	  GPIO_3_FSIRXA_D0                = 0x0006060A,
	  GPIO_3_I2CB_SCL                 = 0x0006060B,
	  GPIO_3_HIC_NOE                  = 0x0006060D,
	  GPIO_3_CANA_RX                  = 0x0006060E,
	  GPIO_3_HIC_D4                   = 0x0006060F,
		
	  GPIO_4_GPIO4                    = 0x00060800,
	  GPIO_4_EPWM3_A                  = 0x00060801,
	  GPIO_4_MCAN_TX                  = 0x00060803,
	  GPIO_4_OUTPUTXBAR3              = 0x00060805,
	  GPIO_4_CANA_TX                  = 0x00060806,
	  GPIO_4_SPIB_CLK                 = 0x00060807,
	  GPIO_4_EQEP2_STROBE             = 0x00060809,
	  GPIO_4_FSIRXA_CLK               = 0x0006080A,
	  GPIO_4_CLB_OUTPUTXBAR6          = 0x0006080B,
	  GPIO_4_HIC_BASESEL2             = 0x0006080D,
	  GPIO_4_HIC_NWE                  = 0x0006080F,
		
	  GPIO_5_GPIO5                    = 0x00060A00,
	  GPIO_5_EPWM3_B                  = 0x00060A01,
	  GPIO_5_OUTPUTXBAR3              = 0x00060A03,
	  GPIO_5_MCAN_RX                  = 0x00060A05,
	  GPIO_5_CANA_RX                  = 0x00060A06,
	  GPIO_5_SPIA_STE                 = 0x00060A07,
	  GPIO_5_FSITXA_D1                = 0x00060A09,
	  GPIO_5_CLB_OUTPUTXBAR5          = 0x00060A0A,
	  GPIO_5_HIC_A7                   = 0x00060A0D,
	  GPIO_5_HIC_D4                   = 0x00060A0E,
	  GPIO_5_HIC_D15                  = 0x00060A0F,
		
	  GPIO_6_GPIO6                    = 0x00060C00,
	  GPIO_6_EPWM4_A                  = 0x00060C01,
	  GPIO_6_OUTPUTXBAR4              = 0x00060C02,
	  GPIO_6_SYNCOUT                  = 0x00060C03,
	  GPIO_6_EQEP1_A                  = 0x00060C05,
	  GPIO_6_SPIB_SOMI                = 0x00060C07,
	  GPIO_6_FSITXA_D0                = 0x00060C09,
	  GPIO_6_FSITXA_D1                = 0x00060C0B,
	  GPIO_6_HIC_NBE1                 = 0x00060C0D,
	  GPIO_6_CLB_OUTPUTXBAR8          = 0x00060C0E,
	  GPIO_6_HIC_D14                  = 0x00060C0F,
		
	  GPIO_7_GPIO7                    = 0x00060E00,
	  GPIO_7_EPWM4_B                  = 0x00060E01,
	  GPIO_7_OUTPUTXBAR5              = 0x00060E03,
	  GPIO_7_EQEP1_B                  = 0x00060E05,
	  GPIO_7_SPIB_SIMO                = 0x00060E07,
	  GPIO_7_FSITXA_CLK               = 0x00060E09,
	  GPIO_7_CLB_OUTPUTXBAR2          = 0x00060E0A,
	  GPIO_7_HIC_A6                   = 0x00060E0D,
	  GPIO_7_HIC_D14                  = 0x00060E0F,
		
	  GPIO_8_GPIO8                    = 0x00061000,
	  GPIO_8_EPWM5_A                  = 0x00061001,
	  GPIO_8_ADCSOCAO                 = 0x00061003,
	  GPIO_8_EQEP1_STROBE             = 0x00061005,
	  GPIO_8_SCIA_TX                  = 0x00061006,
	  GPIO_8_SPIA_SIMO                = 0x00061007,
	  GPIO_8_I2CA_SCL                 = 0x00061009,
	  GPIO_8_FSITXA_D1                = 0x0006100A,
	  GPIO_8_CLB_OUTPUTXBAR5          = 0x0006100B,
	  GPIO_8_HIC_A0                   = 0x0006100D,
	  GPIO_8_FSITXA_TDM_CLK           = 0x0006100E,
	  GPIO_8_HIC_D8                   = 0x0006100F,
		
	  GPIO_9_GPIO9                    = 0x00061200,
	  GPIO_9_EPWM5_B                  = 0x00061201,
	  GPIO_9_SCIB_TX                  = 0x00061202,
	  GPIO_9_OUTPUTXBAR6              = 0x00061203,
	  GPIO_9_EQEP1_INDEX              = 0x00061205,
	  GPIO_9_SCIA_RX                  = 0x00061206,
	  GPIO_9_SPIA_CLK                 = 0x00061207,
	  GPIO_9_FSITXA_D0                = 0x0006120A,
	  GPIO_9_LINB_RX                  = 0x0006120B,
	  GPIO_9_HIC_BASESEL0             = 0x0006120D,
	  GPIO_9_I2CB_SCL                 = 0x0006120E,
	  GPIO_9_HIC_NRDY                 = 0x0006120F,
		
	  GPIO_10_GPIO10                  = 0x00061400,
	  GPIO_10_EPWM6_A                 = 0x00061401,
	  GPIO_10_ADCSOCBO                = 0x00061403,
	  GPIO_10_EQEP1_A                 = 0x00061405,
	  GPIO_10_SCIB_TX                 = 0x00061406,
	  GPIO_10_SPIA_SOMI               = 0x00061407,
	  GPIO_10_I2CA_SDA                = 0x00061409,
	  GPIO_10_FSITXA_CLK              = 0x0006140A,
	  GPIO_10_LINB_TX                 = 0x0006140B,
	  GPIO_10_HIC_NWE                 = 0x0006140D,
	  GPIO_10_FSITXA_TDM_D0           = 0x0006140E,
	  GPIO_10_CLB_OUTPUTXBAR4         = 0x0006140F,
		
	  GPIO_11_GPIO11                  = 0x00061600,
	  GPIO_11_EPWM6_B                 = 0x00061601,
	  GPIO_11_OUTPUTXBAR7             = 0x00061603,
	  GPIO_11_EQEP1_B                 = 0x00061605,
	  GPIO_11_SCIB_RX                 = 0x00061606,
	  GPIO_11_SPIA_STE                = 0x00061607,
	  GPIO_11_FSIRXA_D1               = 0x00061609,
	  GPIO_11_LINB_RX                 = 0x0006160A,
	  GPIO_11_EQEP2_A                 = 0x0006160B,
	  GPIO_11_SPIA_SIMO               = 0x0006160D,
	  GPIO_11_HIC_D6                  = 0x0006160E,
	  GPIO_11_HIC_NBE0                = 0x0006160F,
		
	  GPIO_12_GPIO12                  = 0x00061800,
	  GPIO_12_EPWM7_A                 = 0x00061801,
	  GPIO_12_MCAN_RX                 = 0x00061803,
	  GPIO_12_EQEP1_STROBE            = 0x00061805,
	  GPIO_12_SCIB_TX                 = 0x00061806,
	  GPIO_12_PMBUSA_CTL              = 0x00061807,
	  GPIO_12_FSIRXA_D0               = 0x00061809,
	  GPIO_12_LINB_TX                 = 0x0006180A,
	  GPIO_12_SPIA_CLK                = 0x0006180B,
	  GPIO_12_CANA_RX                 = 0x0006180D,
	  GPIO_12_HIC_D13                 = 0x0006180E,
	  GPIO_12_HIC_INT                 = 0x0006180F,
		
	  GPIO_13_GPIO13                  = 0x00061A00,
	  GPIO_13_EPWM7_B                 = 0x00061A01,
	  GPIO_13_MCAN_TX                 = 0x00061A03,
	  GPIO_13_EQEP1_INDEX             = 0x00061A05,
	  GPIO_13_SCIB_RX                 = 0x00061A06,
	  GPIO_13_PMBUSA_ALERT            = 0x00061A07,
	  GPIO_13_FSIRXA_CLK              = 0x00061A09,
	  GPIO_13_LINB_RX                 = 0x00061A0A,
	  GPIO_13_SPIA_SOMI               = 0x00061A0B,
	  GPIO_13_CANA_TX                 = 0x00061A0D,
	  GPIO_13_HIC_D11                 = 0x00061A0E,
	  GPIO_13_HIC_D5                  = 0x00061A0F,
		
	  GPIO_14_GPIO14                  = 0x00061C00,
	  GPIO_14_EPWM8_A                 = 0x00061C01,
	  GPIO_14_SCIB_TX                 = 0x00061C02,
	  GPIO_14_I2CB_SDA                = 0x00061C05,
	  GPIO_14_OUTPUTXBAR3             = 0x00061C06,
	  GPIO_14_PMBUSA_SDA              = 0x00061C07,
	  GPIO_14_SPIB_CLK                = 0x00061C09,
	  GPIO_14_EQEP2_A                 = 0x00061C0A,
	  GPIO_14_LINB_TX                 = 0x00061C0B,
	  GPIO_14_EPWM3_A                 = 0x00061C0D,
	  GPIO_14_CLB_OUTPUTXBAR7         = 0x00061C0E,
	  GPIO_14_HIC_D15                 = 0x00061C0F,
		
	  GPIO_15_GPIO15                  = 0x00061E00,
	  GPIO_15_EPWM8_B                 = 0x00061E01,
	  GPIO_15_SCIB_RX                 = 0x00061E02,
	  GPIO_15_I2CB_SCL                = 0x00061E05,
	  GPIO_15_OUTPUTXBAR4             = 0x00061E06,
	  GPIO_15_PMBUSA_SCL              = 0x00061E07,
	  GPIO_15_SPIB_STE                = 0x00061E09,
	  GPIO_15_EQEP2_B                 = 0x00061E0A,
	  GPIO_15_LINB_RX                 = 0x00061E0B,
	  GPIO_15_EPWM3_B                 = 0x00061E0D,
	  GPIO_15_CLB_OUTPUTXBAR6         = 0x00061E0E,
	  GPIO_15_HIC_D12                 = 0x00061E0F,
		
	  GPIO_16_GPIO16                  = 0x00080000,
	  GPIO_16_SPIA_SIMO               = 0x00080001,
	  GPIO_16_OUTPUTXBAR7             = 0x00080003,
	  GPIO_16_EPWM5_A                 = 0x00080005,
	  GPIO_16_SCIA_TX                 = 0x00080006,
	  GPIO_16_SD1_D1                  = 0x00080007,
	  GPIO_16_EQEP1_STROBE            = 0x00080009,
	  GPIO_16_PMBUSA_SCL              = 0x0008000A,
	  GPIO_16_XCLKOUT                 = 0x0008000B,
	  GPIO_16_EQEP2_B                 = 0x0008000D,
	  GPIO_16_SPIB_SOMI               = 0x0008000E,
	  GPIO_16_HIC_D1                  = 0x0008000F,
		
	  GPIO_17_GPIO17                  = 0x00080200,
	  GPIO_17_SPIA_SOMI               = 0x00080201,
	  GPIO_17_OUTPUTXBAR8             = 0x00080203,
	  GPIO_17_EPWM5_B                 = 0x00080205,
	  GPIO_17_SCIA_RX                 = 0x00080206,
	  GPIO_17_SD1_C1                  = 0x00080207,
	  GPIO_17_EQEP1_INDEX             = 0x00080209,
	  GPIO_17_PMBUSA_SDA              = 0x0008020A,
	  GPIO_17_CANA_TX                 = 0x0008020B,
	  GPIO_17_HIC_D2                  = 0x0008020F,
		
	  GPIO_18_GPIO18                  = 0x00080400,
	  GPIO_18_SPIA_CLK                = 0x00080401,
	  GPIO_18_SCIB_TX                 = 0x00080402,
	  GPIO_18_CANA_RX                 = 0x00080403,
	  GPIO_18_EPWM6_A                 = 0x00080405,
	  GPIO_18_I2CA_SCL                = 0x00080406,
	  GPIO_18_SD1_D2                  = 0x00080407,
	  GPIO_18_EQEP2_A                 = 0x00080409,
	  GPIO_18_PMBUSA_CTL              = 0x0008040A,
	  GPIO_18_XCLKOUT                 = 0x0008040B,
	  GPIO_18_LINB_TX                 = 0x0008040D,
	  GPIO_18_FSITXA_TDM_CLK          = 0x0008040E,
	  GPIO_18_HIC_INT                 = 0x0008040F,
		
	  GPIO_19_GPIO19                  = 0x00080600,
	  GPIO_19_SPIA_STE                = 0x00080601,
	  GPIO_19_SCIB_RX                 = 0x00080602,
	  GPIO_19_CANA_TX                 = 0x00080603,
	  GPIO_19_EPWM6_B                 = 0x00080605,
	  GPIO_19_I2CA_SDA                = 0x00080606,
	  GPIO_19_SD1_C2                  = 0x00080607,
	  GPIO_19_EQEP2_B                 = 0x00080609,
	  GPIO_19_PMBUSA_ALERT            = 0x0008060A,
	  GPIO_19_CLB_OUTPUTXBAR1         = 0x0008060B,
	  GPIO_19_LINB_RX                 = 0x0008060D,
	  GPIO_19_FSITXA_TDM_D0           = 0x0008060E,
	  GPIO_19_HIC_NBE0                = 0x0008060F,
		
	  GPIO_20_GPIO20                  = 0x00080800,
	  GPIO_20_EQEP1_A                 = 0x00080801,
	  GPIO_20_SPIB_SIMO               = 0x00080806,
	  GPIO_20_SD1_D3                  = 0x00080807,
	  GPIO_20_MCAN_TX                 = 0x00080809,
		
	  GPIO_21_GPIO21                  = 0x00080A00,
	  GPIO_21_EQEP1_B                 = 0x00080A01,
	  GPIO_21_SPIB_SOMI               = 0x00080A06,
	  GPIO_21_SD1_C3                  = 0x00080A07,
	  GPIO_21_MCAN_RX                 = 0x00080A09,
		
	  GPIO_22_GPIO22                  = 0x00080C00,
	  GPIO_22_EQEP1_STROBE            = 0x00080C01,
	  GPIO_22_SCIB_TX                 = 0x00080C03,
	  GPIO_22_SPIB_CLK                = 0x00080C06,
	  GPIO_22_SD1_D4                  = 0x00080C07,
	  GPIO_22_LINA_TX                 = 0x00080C09,
	  GPIO_22_CLB_OUTPUTXBAR1         = 0x00080C0A,
	  GPIO_22_LINB_TX                 = 0x00080C0B,
	  GPIO_22_HIC_A5                  = 0x00080C0D,
	  GPIO_22_EPWM4_A                 = 0x00080C0E,
	  GPIO_22_HIC_D13                 = 0x00080C0F,
		
	  GPIO_23_GPIO23                  = 0x00080E00,
	  GPIO_23_EQEP1_INDEX             = 0x00080E01,
	  GPIO_23_SCIB_RX                 = 0x00080E03,
	  GPIO_23_SPIB_STE                = 0x00080E06,
	  GPIO_23_SD1_C4                  = 0x00080E07,
	  GPIO_23_LINA_RX                 = 0x00080E09,
	  GPIO_23_CLB_OUTPUTXBAR3         = 0x00080E0A,
	  GPIO_23_LINB_RX                 = 0x00080E0B,
	  GPIO_23_HIC_A3                  = 0x00080E0D,
	  GPIO_23_EPWM4_B                 = 0x00080E0E,
	  GPIO_23_HIC_D11                 = 0x00080E0F,
		
	  GPIO_24_GPIO24                  = 0x00081000,
	  GPIO_24_OUTPUTXBAR1             = 0x00081001,
	  GPIO_24_EQEP2_A                 = 0x00081002,
	  GPIO_24_EPWM8_A                 = 0x00081005,
	  GPIO_24_SPIB_SIMO               = 0x00081006,
	  GPIO_24_SD2_D1                  = 0x00081007,
	  GPIO_24_LINB_TX                 = 0x00081009,
	  GPIO_24_PMBUSA_SCL              = 0x0008100A,
	  GPIO_24_SCIA_TX                 = 0x0008100B,
	  GPIO_24_ERRORSTS                = 0x0008100D,
	  GPIO_24_HIC_D3                  = 0x0008100F,
		
	  GPIO_25_GPIO25                  = 0x00081200,
	  GPIO_25_OUTPUTXBAR2             = 0x00081201,
	  GPIO_25_EQEP2_B                 = 0x00081202,
	  GPIO_25_EQEP1_A                 = 0x00081205,
	  GPIO_25_SPIB_SOMI               = 0x00081206,
	  GPIO_25_SD2_C1                  = 0x00081207,
	  GPIO_25_FSITXA_D1               = 0x00081209,
	  GPIO_25_PMBUSA_SDA              = 0x0008120A,
	  GPIO_25_SCIA_RX                 = 0x0008120B,
	  GPIO_25_HIC_BASESEL0            = 0x0008120E,
		
	  GPIO_26_GPIO26                  = 0x00081400,
	  GPIO_26_OUTPUTXBAR3             = 0x00081401,
	  GPIO_26_EQEP2_INDEX             = 0x00081402,
	  GPIO_26_SPIB_CLK                = 0x00081406,
	  GPIO_26_SD2_D2                  = 0x00081407,
	  GPIO_26_FSITXA_D0               = 0x00081409,
	  GPIO_26_PMBUSA_CTL              = 0x0008140A,
	  GPIO_26_I2CA_SDA                = 0x0008140B,
	  GPIO_26_HIC_D0                  = 0x0008140E,
	  GPIO_26_HIC_A1                  = 0x0008140F,
		
	  GPIO_27_GPIO27                  = 0x00081600,
	  GPIO_27_OUTPUTXBAR4             = 0x00081601,
	  GPIO_27_EQEP2_STROBE            = 0x00081602,
	  GPIO_27_SPIB_STE                = 0x00081606,
	  GPIO_27_SD2_C2                  = 0x00081607,
	  GPIO_27_FSITXA_CLK              = 0x00081609,
	  GPIO_27_PMBUSA_ALERT            = 0x0008160A,
	  GPIO_27_I2CA_SCL                = 0x0008160B,
	  GPIO_27_HIC_D1                  = 0x0008160E,
	  GPIO_27_HIC_A4                  = 0x0008160F,
		
	  GPIO_28_GPIO28                  = 0x00081800,
	  GPIO_28_SCIA_RX                 = 0x00081801,
	  GPIO_28_EPWM7_A                 = 0x00081803,
	  GPIO_28_OUTPUTXBAR5             = 0x00081805,
	  GPIO_28_EQEP1_A                 = 0x00081806,
	  GPIO_28_SD2_D3                  = 0x00081807,
	  GPIO_28_EQEP2_STROBE            = 0x00081809,
	  GPIO_28_LINA_TX                 = 0x0008180A,
	  GPIO_28_SPIB_CLK                = 0x0008180B,
	  GPIO_28_ERRORSTS                = 0x0008180D,
	  GPIO_28_I2CB_SDA                = 0x0008180E,
	  GPIO_28_HIC_NOE                 = 0x0008180F,
		
	  GPIO_29_GPIO29                  = 0x00081A00,
	  GPIO_29_SCIA_TX                 = 0x00081A01,
	  GPIO_29_EPWM7_B                 = 0x00081A03,
	  GPIO_29_OUTPUTXBAR6             = 0x00081A05,
	  GPIO_29_EQEP1_B                 = 0x00081A06,
	  GPIO_29_SD2_C3                  = 0x00081A07,
	  GPIO_29_EQEP2_INDEX             = 0x00081A09,
	  GPIO_29_LINA_RX                 = 0x00081A0A,
	  GPIO_29_SPIB_STE                = 0x00081A0B,
	  GPIO_29_ERRORSTS                = 0x00081A0D,
	  GPIO_29_I2CB_SCL                = 0x00081A0E,
	  GPIO_29_HIC_NCS                 = 0x00081A0F,
		
	  GPIO_30_GPIO30                  = 0x00081C00,
	  GPIO_30_CANA_RX                 = 0x00081C01,
	  GPIO_30_SPIB_SIMO               = 0x00081C03,
	  GPIO_30_OUTPUTXBAR7             = 0x00081C05,
	  GPIO_30_EQEP1_STROBE            = 0x00081C06,
	  GPIO_30_SD2_D4                  = 0x00081C07,
	  GPIO_30_FSIRXA_CLK              = 0x00081C09,
	  GPIO_30_MCAN_RX                 = 0x00081C0A,
	  GPIO_30_EPWM1_A                 = 0x00081C0B,
	  GPIO_30_HIC_D8                  = 0x00081C0E,
		
	  GPIO_31_GPIO31                  = 0x00081E00,
	  GPIO_31_CANA_TX                 = 0x00081E01,
	  GPIO_31_SPIB_SOMI               = 0x00081E03,
	  GPIO_31_OUTPUTXBAR8             = 0x00081E05,
	  GPIO_31_EQEP1_INDEX             = 0x00081E06,
	  GPIO_31_SD2_C4                  = 0x00081E07,
	  GPIO_31_FSIRXA_D1               = 0x00081E09,
	  GPIO_31_MCAN_TX                 = 0x00081E0A,
	  GPIO_31_EPWM1_B                 = 0x00081E0B,
	  GPIO_31_HIC_D10                 = 0x00081E0E,
		
	  GPIO_32_GPIO32                  = 0x00460000,
	  GPIO_32_I2CA_SDA                = 0x00460001,
	  GPIO_32_SPIB_CLK                = 0x00460003,
	  GPIO_32_EPWM8_B                 = 0x00460005,
	  GPIO_32_LINA_TX                 = 0x00460006,
	  GPIO_32_SD1_D2                  = 0x00460007,
	  GPIO_32_FSIRXA_D0               = 0x00460009,
	  GPIO_32_CANA_TX                 = 0x0046000A,
	  GPIO_32_PMBUSA_SDA              = 0x0046000B,
	  GPIO_32_ADCSOCBO                = 0x0046000D,
	  GPIO_32_HIC_INT                 = 0x0046000F,
		
	  GPIO_33_GPIO33                  = 0x00460200,
	  GPIO_33_I2CA_SCL                = 0x00460201,
	  GPIO_33_SPIB_STE                = 0x00460203,
	  GPIO_33_OUTPUTXBAR4             = 0x00460205,
	  GPIO_33_LINA_RX                 = 0x00460206,
	  GPIO_33_SD1_C2                  = 0x00460207,
	  GPIO_33_FSIRXA_CLK              = 0x00460209,
	  GPIO_33_CANA_RX                 = 0x0046020A,
	  GPIO_33_EQEP2_B                 = 0x0046020B,
	  GPIO_33_ADCSOCAO                = 0x0046020D,
	  GPIO_33_SD1_C1                  = 0x0046020E,
	  GPIO_33_HIC_D0                  = 0x0046020F,
		
	  GPIO_34_GPIO34                  = 0x00460400,
	  GPIO_34_OUTPUTXBAR1             = 0x00460401,
	  GPIO_34_PMBUSA_SDA              = 0x00460406,
	  GPIO_34_HIC_NBE1                = 0x0046040D,
	  GPIO_34_I2CB_SDA                = 0x0046040E,
	  GPIO_34_HIC_D9                  = 0x0046040F,
		
	  GPIO_35_GPIO35                  = 0x00460600,
	  GPIO_35_SCIA_RX                 = 0x00460601,
	  GPIO_35_I2CA_SDA                = 0x00460603,
	  GPIO_35_CANA_RX                 = 0x00460605,
	  GPIO_35_PMBUSA_SCL              = 0x00460606,
	  GPIO_35_LINA_RX                 = 0x00460607,
	  GPIO_35_EQEP1_A                 = 0x00460609,
	  GPIO_35_PMBUSA_CTL              = 0x0046060A,
	  GPIO_35_EPWM5_B                 = 0x0046060B,
	  GPIO_35_SD2_C1                  = 0x0046060D,
	  GPIO_35_HIC_NWE                 = 0x0046060E,
	  GPIO_35_TDI                     = 0x0046060F,
		
	  GPIO_37_GPIO37                  = 0x00460A00,
	  GPIO_37_OUTPUTXBAR2             = 0x00460A01,
	  GPIO_37_I2CA_SCL                = 0x00460A03,
	  GPIO_37_SCIA_TX                 = 0x00460A05,
	  GPIO_37_CANA_TX                 = 0x00460A06,
	  GPIO_37_LINA_TX                 = 0x00460A07,
	  GPIO_37_EQEP1_B                 = 0x00460A09,
	  GPIO_37_PMBUSA_ALERT            = 0x00460A0A,
	  GPIO_37_HIC_NRDY                = 0x00460A0E,
	  GPIO_37_TDO                     = 0x00460A0F,
		
	  GPIO_39_GPIO39                  = 0x00460E00,
	  GPIO_39_MCAN_RX                 = 0x00460E06,
	  GPIO_39_FSIRXA_CLK              = 0x00460E07,
	  GPIO_39_EQEP2_INDEX             = 0x00460E09,
	  GPIO_39_CLB_OUTPUTXBAR2         = 0x00460E0B,
	  GPIO_39_SYNCOUT                 = 0x00460E0D,
	  GPIO_39_EQEP1_INDEX             = 0x00460E0E,
	  GPIO_39_HIC_D7                  = 0x00460E0F,
		
	  GPIO_40_GPIO40                  = 0x00461000,
	  GPIO_40_SPIB_SIMO               = 0x00461001,
	  GPIO_40_EPWM2_B                 = 0x00461005,
	  GPIO_40_PMBUSA_SDA              = 0x00461006,
	  GPIO_40_FSIRXA_D0               = 0x00461007,
	  GPIO_40_SCIB_TX                 = 0x00461009,
	  GPIO_40_EQEP1_A                 = 0x0046100A,
	  GPIO_40_LINB_TX                 = 0x0046100B,
	  GPIO_40_HIC_NBE1                = 0x0046100E,
	  GPIO_40_HIC_D5                  = 0x0046100F,
		
	  GPIO_41_GPIO41                  = 0x00461200,
	  GPIO_41_EPWM2_A                 = 0x00461205,
	  GPIO_41_PMBUSA_SCL              = 0x00461206,
	  GPIO_41_FSIRXA_D1               = 0x00461207,
	  GPIO_41_SCIB_RX                 = 0x00461209,
	  GPIO_41_EQEP1_B                 = 0x0046120A,
	  GPIO_41_LINB_RX                 = 0x0046120B,
	  GPIO_41_HIC_A4                  = 0x0046120D,
	  GPIO_41_SPIB_SOMI               = 0x0046120E,
	  GPIO_41_HIC_D12                 = 0x0046120F,
		
	  GPIO_42_GPIO42                  = 0x00461400,
	  GPIO_42_LINA_RX                 = 0x00461402,
	  GPIO_42_OUTPUTXBAR5             = 0x00461403,
	  GPIO_42_PMBUSA_CTL              = 0x00461405,
	  GPIO_42_I2CA_SDA                = 0x00461406,
	  GPIO_42_EQEP1_STROBE            = 0x0046140A,
	  GPIO_42_CLB_OUTPUTXBAR3         = 0x0046140B,
	  GPIO_42_HIC_D2                  = 0x0046140E,
	  GPIO_42_HIC_A6                  = 0x0046140F,
		
	  GPIO_43_GPIO43                  = 0x00461600,
	  GPIO_43_OUTPUTXBAR6             = 0x00461603,
	  GPIO_43_PMBUSA_ALERT            = 0x00461605,
	  GPIO_43_I2CA_SCL                = 0x00461606,
	  GPIO_43_EQEP1_INDEX             = 0x0046160A,
	  GPIO_43_CLB_OUTPUTXBAR4         = 0x0046160B,
	  GPIO_43_SD2_D3                  = 0x0046160D,
	  GPIO_43_HIC_D3                  = 0x0046160E,
	  GPIO_43_HIC_A7                  = 0x0046160F,
		
	  GPIO_44_GPIO44                  = 0x00461800,
	  GPIO_44_OUTPUTXBAR7             = 0x00461803,
	  GPIO_44_EQEP1_A                 = 0x00461805,
	  GPIO_44_PMBUSA_SDA              = 0x00461806,
	  GPIO_44_FSITXA_CLK              = 0x00461807,
	  GPIO_44_PMBUSA_CTL              = 0x00461809,
	  GPIO_44_CLB_OUTPUTXBAR3         = 0x0046180A,
	  GPIO_44_FSIRXA_D0               = 0x0046180B,
	  GPIO_44_HIC_D7                  = 0x0046180D,
	  GPIO_44_LINB_TX                 = 0x0046180E,
	  GPIO_44_HIC_D5                  = 0x0046180F,
		
	  GPIO_45_GPIO45                  = 0x00461A00,
	  GPIO_45_OUTPUTXBAR8             = 0x00461A03,
	  GPIO_45_FSITXA_D0               = 0x00461A07,
	  GPIO_45_PMBUSA_ALERT            = 0x00461A09,
	  GPIO_45_CLB_OUTPUTXBAR4         = 0x00461A0A,
	  GPIO_45_SD2_C3                  = 0x00461A0D,
	  GPIO_45_HIC_D6                  = 0x00461A0F,
		
	  GPIO_46_GPIO46                  = 0x00461C00,
	  GPIO_46_LINA_TX                 = 0x00461C03,
	  GPIO_46_MCAN_TX                 = 0x00461C05,
	  GPIO_46_FSITXA_D1               = 0x00461C07,
	  GPIO_46_PMBUSA_SDA              = 0x00461C09,
	  GPIO_46_SD2_C4                  = 0x00461C0D,
	  GPIO_46_HIC_NWE                 = 0x00461C0F,
		
	  GPIO_47_GPIO47                  = 0x00461E00,
	  GPIO_47_LINA_RX                 = 0x00461E03,
	  GPIO_47_MCAN_RX                 = 0x00461E05,
	  GPIO_47_CLB_OUTPUTXBAR2         = 0x00461E07,
	  GPIO_47_PMBUSA_SCL              = 0x00461E09,
	  GPIO_47_SD2_D4                  = 0x00461E0D,
	  GPIO_47_FSITXA_TDM_CLK          = 0x00461E0E,
	  GPIO_47_HIC_A6                  = 0x00461E0F,
		
	  GPIO_48_GPIO48                  = 0x00480000,
	  GPIO_48_OUTPUTXBAR3             = 0x00480001,
	  GPIO_48_CANA_TX                 = 0x00480003,
	  GPIO_48_SCIA_TX                 = 0x00480006,
	  GPIO_48_SD1_D1                  = 0x00480007,
	  GPIO_48_PMBUSA_SDA              = 0x00480009,
	  GPIO_48_HIC_A7                  = 0x0048000F,
		
	  GPIO_49_GPIO49                  = 0x00480200,
	  GPIO_49_OUTPUTXBAR4             = 0x00480201,
	  GPIO_49_CANA_RX                 = 0x00480203,
	  GPIO_49_SCIA_RX                 = 0x00480206,
	  GPIO_49_SD1_C1                  = 0x00480207,
	  GPIO_49_LINA_RX                 = 0x00480209,
	  GPIO_49_SD2_D1                  = 0x0048020D,
	  GPIO_49_FSITXA_D0               = 0x0048020E,
	  GPIO_49_HIC_D2                  = 0x0048020F,
		
	  GPIO_50_GPIO50                  = 0x00480400,
	  GPIO_50_EQEP1_A                 = 0x00480401,
	  GPIO_50_MCAN_TX                 = 0x00480405,
	  GPIO_50_SPIB_SIMO               = 0x00480406,
	  GPIO_50_SD1_D2                  = 0x00480407,
	  GPIO_50_I2CB_SDA                = 0x00480409,
	  GPIO_50_SD2_D2                  = 0x0048040D,
	  GPIO_50_FSITXA_D1               = 0x0048040E,
	  GPIO_50_HIC_D3                  = 0x0048040F,
		
	  GPIO_51_GPIO51                  = 0x00480600,
	  GPIO_51_EQEP1_B                 = 0x00480601,
	  GPIO_51_MCAN_RX                 = 0x00480605,
	  GPIO_51_SPIB_SOMI               = 0x00480606,
	  GPIO_51_SD1_C2                  = 0x00480607,
	  GPIO_51_I2CB_SCL                = 0x00480609,
	  GPIO_51_SD2_D3                  = 0x0048060D,
	  GPIO_51_FSITXA_CLK              = 0x0048060E,
	  GPIO_51_HIC_D6                  = 0x0048060F,
		
	  GPIO_52_GPIO52                  = 0x00480800,
	  GPIO_52_EQEP1_STROBE            = 0x00480801,
	  GPIO_52_CLB_OUTPUTXBAR5         = 0x00480805,
	  GPIO_52_SPIB_CLK                = 0x00480806,
	  GPIO_52_SD1_D3                  = 0x00480807,
	  GPIO_52_SYNCOUT                 = 0x00480809,
	  GPIO_52_SD2_D4                  = 0x0048080D,
	  GPIO_52_FSIRXA_D0               = 0x0048080E,
	  GPIO_52_HIC_NWE                 = 0x0048080F,
		
	  GPIO_53_GPIO53                  = 0x00480A00,
	  GPIO_53_EQEP1_INDEX             = 0x00480A01,
	  GPIO_53_CLB_OUTPUTXBAR6         = 0x00480A05,
	  GPIO_53_SPIB_STE                = 0x00480A06,
	  GPIO_53_SD1_C3                  = 0x00480A07,
	  GPIO_53_ADCSOCAO                = 0x00480A09,
	  GPIO_53_CANA_RX                 = 0x00480A0A,
	  GPIO_53_SD1_C1                  = 0x00480A0D,
	  GPIO_53_FSIRXA_D1               = 0x00480A0E,
		
	  GPIO_54_GPIO54                  = 0x00480C00,
	  GPIO_54_SPIA_SIMO               = 0x00480C01,
	  GPIO_54_EQEP2_A                 = 0x00480C05,
	  GPIO_54_OUTPUTXBAR2             = 0x00480C06,
	  GPIO_54_SD1_D4                  = 0x00480C07,
	  GPIO_54_ADCSOCBO                = 0x00480C09,
	  GPIO_54_LINB_TX                 = 0x00480C0A,
	  GPIO_54_SD1_C2                  = 0x00480C0D,
	  GPIO_54_FSIRXA_CLK              = 0x00480C0E,
	  GPIO_54_FSITXA_TDM_D1           = 0x00480C0F,
		
	  GPIO_55_GPIO55                  = 0x00480E00,
	  GPIO_55_SPIA_SOMI               = 0x00480E01,
	  GPIO_55_EQEP2_B                 = 0x00480E05,
	  GPIO_55_OUTPUTXBAR3             = 0x00480E06,
	  GPIO_55_SD1_C4                  = 0x00480E07,
	  GPIO_55_ERRORSTS                = 0x00480E09,
	  GPIO_55_LINB_RX                 = 0x00480E0A,
	  GPIO_55_SD1_C3                  = 0x00480E0D,
	  GPIO_55_HIC_A0                  = 0x00480E0F,
		
	  GPIO_56_GPIO56                  = 0x00481000,
	  GPIO_56_SPIA_CLK                = 0x00481001,
	  GPIO_56_CLB_OUTPUTXBAR7         = 0x00481002,
	  GPIO_56_MCAN_TX                 = 0x00481003,
	  GPIO_56_EQEP2_STROBE            = 0x00481005,
	  GPIO_56_SCIB_TX                 = 0x00481006,
	  GPIO_56_SD2_D1                  = 0x00481007,
	  GPIO_56_SPIB_SIMO               = 0x00481009,
	  GPIO_56_I2CA_SDA                = 0x0048100A,
	  GPIO_56_EQEP1_A                 = 0x0048100B,
	  GPIO_56_SD1_C4                  = 0x0048100D,
	  GPIO_56_FSIRXA_D1               = 0x0048100E,
	  GPIO_56_HIC_D6                  = 0x0048100F,
		
	  GPIO_57_GPIO57                  = 0x00481200,
	  GPIO_57_SPIA_STE                = 0x00481201,
	  GPIO_57_CLB_OUTPUTXBAR8         = 0x00481202,
	  GPIO_57_MCAN_RX                 = 0x00481203,
	  GPIO_57_EQEP2_INDEX             = 0x00481205,
	  GPIO_57_SCIB_RX                 = 0x00481206,
	  GPIO_57_SD2_C1                  = 0x00481207,
	  GPIO_57_SPIB_SOMI               = 0x00481209,
	  GPIO_57_I2CA_SCL                = 0x0048120A,
	  GPIO_57_EQEP1_B                 = 0x0048120B,
	  GPIO_57_FSIRXA_CLK              = 0x0048120E,
	  GPIO_57_HIC_D4                  = 0x0048120F,
		
	  GPIO_58_GPIO58                  = 0x00481400,
	  GPIO_58_OUTPUTXBAR1             = 0x00481405,
	  GPIO_58_SPIB_CLK                = 0x00481406,
	  GPIO_58_SD2_D2                  = 0x00481407,
	  GPIO_58_LINA_TX                 = 0x00481409,
	  GPIO_58_CANA_TX                 = 0x0048140A,
	  GPIO_58_EQEP1_STROBE            = 0x0048140B,
	  GPIO_58_SD2_C2                  = 0x0048140D,
	  GPIO_58_FSIRXA_D0               = 0x0048140E,
	  GPIO_58_HIC_NRDY                = 0x0048140F,
		
	  GPIO_59_GPIO59                  = 0x00481600,
	  GPIO_59_OUTPUTXBAR2             = 0x00481605,
	  GPIO_59_SPIB_STE                = 0x00481606,
	  GPIO_59_SD2_C2                  = 0x00481607,
	  GPIO_59_LINA_RX                 = 0x00481609,
	  GPIO_59_CANA_RX                 = 0x0048160A,
	  GPIO_59_EQEP1_INDEX             = 0x0048160B,
	  GPIO_59_SD2_C3                  = 0x0048160D,
	  GPIO_59_FSITXA_TDM_D1           = 0x0048160E,
		
	  GPIO_60_GPIO60                  = 0x00481800,
	  GPIO_60_MCAN_TX                 = 0x00481803,
	  GPIO_60_OUTPUTXBAR3             = 0x00481805,
	  GPIO_60_SPIB_SIMO               = 0x00481806,
	  GPIO_60_SD2_D3                  = 0x00481807,
	  GPIO_60_SD2_C4                  = 0x0048180D,
	  GPIO_60_HIC_A0                  = 0x0048180F,
		
	  GPIO_61_GPIO61                  = 0x00481A00,
	  GPIO_61_MCAN_RX                 = 0x00481A03,
	  GPIO_61_OUTPUTXBAR4             = 0x00481A05,
	  GPIO_61_SPIB_SOMI               = 0x00481A06,
	  GPIO_61_SD2_C3                  = 0x00481A07,
	  GPIO_61_CANA_RX                 = 0x00481A0E,
		
	  GPIO_224_GPIO224                = 0x01C60000,
	  GPIO_224_SD2_D3                 = 0x01C60002,
	  GPIO_224_HIC_A3                 = 0x01C6000F,
		
	  GPIO_225_GPIO225                = 0x01C60200,
	  GPIO_225_SD2_C2                 = 0x01C60202,
	  GPIO_225_HIC_NWE                = 0x01C6020F,
		
	  GPIO_226_GPIO226                = 0x01C60400,
	  GPIO_226_SD2_D4                 = 0x01C60402,
	  GPIO_226_HIC_A1                 = 0x01C6040F,
		
	  GPIO_227_GPIO227                = 0x01C60600,
	  GPIO_227_SD1_C3                 = 0x01C60602,
	  GPIO_227_HIC_NBE0               = 0x01C6060F,
		
	  GPIO_228_GPIO228                = 0x01C60800,
	  GPIO_228_SD2_C1                 = 0x01C60802,
	  GPIO_228_HIC_A0                 = 0x01C6080F,
		
	  GPIO_229_GPIO229                = 0x01C60A00,
		
	  GPIO_230_GPIO230                = 0x01C60C00,
	  GPIO_230_SD1_C4                 = 0x01C60C02,
	  GPIO_230_HIC_BASESEL2           = 0x01C60C0F,
		
	  GPIO_231_GPIO231                = 0x01C60E00,
	  GPIO_231_SD1_C1                 = 0x01C60E02,
	  GPIO_231_HIC_BASESEL1           = 0x01C60E0F,
		
	  GPIO_232_GPIO232                = 0x01C61000,
	  GPIO_232_SD1_D4                 = 0x01C61002,
	  GPIO_232_HIC_BASESEL0           = 0x01C6100F,
		
	  GPIO_233_GPIO233                = 0x01C61200,
	  GPIO_233_SD2_D1                 = 0x01C61202,
	  GPIO_233_HIC_A4                 = 0x01C6120F,
		
	  GPIO_236_GPIO236                = 0x01C61800,
		
	  GPIO_237_GPIO237                = 0x01C61A00,
	  GPIO_237_SD1_D2                 = 0x01C61A02,
	  GPIO_237_HIC_A6                 = 0x01C61A0F,
		
	  GPIO_238_GPIO238                = 0x01C61C00,
	  GPIO_238_SD2_C3                 = 0x01C61C02,
	  GPIO_238_HIC_NCS                = 0x01C61C0F,
		
	  GPIO_239_GPIO239                = 0x01C61E00,
	  GPIO_239_SD1_D1                 = 0x01C61E02,
	  GPIO_239_HIC_A5                 = 0x01C61E0F,
		
	  GPIO_240_GPIO240                = 0x01C80000,
	  GPIO_240_SD2_C1                 = 0x01C80002,
	  GPIO_240_HIC_NBE1               = 0x01C8000F,
		
	  GPIO_241_GPIO241                = 0x01C80200,
	  GPIO_241_SD2_C1                 = 0x01C80202,
	  GPIO_241_HIC_NBE1               = 0x01C8020F,
		
	  GPIO_242_GPIO242                = 0x01C80400,
	  GPIO_242_SD2_D2                 = 0x01C80402,
	  GPIO_242_HIC_A2                 = 0x01C8040F,
		
	  GPIO_244_GPIO244                = 0x01C80800,
	  GPIO_244_SD1_D3                 = 0x01C80802,
	  GPIO_244_HIC_A7                 = 0x01C8080F,
		
	  GPIO_245_GPIO245                = 0x01C80A00,
	  GPIO_245_SD1_C2                 = 0x01C80A02,
	  GPIO_245_HIC_NOE                = 0x01C80A0F,
		
	  GPIO_247_GPIO247                = 0x01C80E00,
		
	  GPIO_248_GPIO248                = 0x01C81000,
		
	  GPIO_249_GPIO249                = 0x01C81200,
		
	  GPIO_251_GPIO251                = 0x01C81600,
		
	  GPIO_252_GPIO252                = 0x01C81800,
	  GPIO_252_SD2_C4                 = 0x01C81802,
		
	  GPIO_253_GPIO253                = 0x01C81A00,
	}
	return pin_map[pin]
end

return P
