--entry_point="code_start"
--retain="reset_vector"
--retain="nmi_vector"

/* Specify the system memory map */

MEMORY
{
    /*
     *  RAM
     */
    SRAM_CPA0 : o=0x20110000, l=0x008000

    // CDA RAM
    CPU1TOCPU2RAM    : origin = 0x20120000, length = 0x0006FE
    SCOPE_FLAG_CPU1  : origin = 0x201206FE, length = 0x000002
    CPU1TOCPU2LINK   : origin = 0x20120700, length = 0x000100

    CPU2TOCPU1RAM    : origin = 0x20120800, length = 0x0006FE
    SCOPE_FLAG_CPU2  : origin = 0x20120EFE, length = 0x000002
    CPU2TOCPU1LINK   : origin = 0x20120F00, length = 0x000100

    SRAM_CDAx : o=0x20121000, l=0x2F000

    CERT : o=0x10400000, l=0x1000
    FLASH_RP0 : o=0x10401000, l=0xFF000 // full size minus certificate
}


/* Specify the sections allocation into memory */

SECTIONS
{
    cpu1to2_ram : {CPU1TOCPU2RAM_BASE = .;} > CPU1TOCPU2RAM, TYPE = NOLOAD
    cpu2to1_ram : {CPU2TOCPU1RAM_BASE = .;} > CPU2TOCPU1RAM, TYPE = NOLOAD

    scopeflag_remote   : {} > SCOPE_FLAG_CPU1
    scopeflag_local    : {} > SCOPE_FLAG_CPU2

    cpu1to2_link_mem : {} > CPU1TOCPU2LINK, TYPE = NOLOAD
    cpu2to1_link_mem : {} > CPU2TOCPU1LINK, TYPE = NOLOAD

    cert          : {} > CERT,          palign(8)
    resetvector   : {} > 0x10401000,    palign(8)
    nmivector     : {} > 0x10401040,    palign(8)
    codestart     : {} > FLASH_RP0,     palign(8)
    .text         : {} > FLASH_RP0,     palign(8)
    .binit        : {} > FLASH_RP0,     palign(8)
    .cinit        : {} > FLASH_RP0,     palign(8)
    .const        : {} > FLASH_RP0,     palign(8)
    .rodata       : {} > FLASH_RP0,     palign(8)
    .init_array   : {} > FLASH_RP0,     palign(8)
    .TI.ramfunc   : {} LOAD=FLASH_RP0, RUN=SRAM_CPA0, table(BINIT),     palign(8)

    .data         : {} > SRAM_CDAx
    .bss          : {} > SRAM_CDAx
    .stack        : {} > SRAM_CDAx
    .sysmem       : {} > SRAM_CDAx
    .cio          : {} > SRAM_CDAx
}
